package cn.com.duiba.prize.center.api.enums;

/**
 * ClassName:PrizeCenterErrorEnum<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 错误码 统一定义   规范参考http://cf.dui88.com/pages/viewpage.action?pageId=7676317
 * @date 创建时间：2018/3/14  11:23
 * @since JDK 1.8
 **/
public enum PrizeCenterErrorEnum {
    CODE_2003001001("2003001001","暂时不支持查询改类型活动奖品配置"),
    CODE_2003001002("2003001002","活动工具奖品配置获取异常"),
    CODE_2003001003("2003001003", "商品未找到"),
    CODE_2003001004("2003001004","商品失效"),
    CODE_2003001005("2003001005","商品删除或下架"),
    CODE_2003001006("2003001006","限时,限量,会员等级限制,兑换限制,日期限制"),
    CODE_2003001007("2003001007","APP兑换限制只能测试专用商品"),
    CODE_2003001008("2003001008","商品库存不足"),
    CODE_2003001009("2003001009","商品过期"),
    CODE_2003001010("2003001010","虚拟商品接口未配"),
    CODE_2003001011("2003001011","虚拟商品档位不存在"),
    CODE_2003001012("2003001012","地域限制"),
    CODE_2003001013("2003001013","兑吧余额不足"),
    CODE_2003001014("2003001014","开发者日预算不足"),
    CODE_2003001015("2003001015","开发者月预算不足"),
    CODE_2003001016("2003001016","开发者余额不足"),
    CODE_2003001017("2003001017","保底人数不够"),
    CODE_2003001018("2003001018","奖项中奖限制"),
    CODE_2003001019("2003001019","防作弊命中"),
    CODE_2003002001("2003002001","防作弊命中"),

    CODE_2003003001("2003003001","主订单生成失败"),
    CODE_2003003002("2003003002","虚拟商品订单生成失败"),
    CODE_2003003003("2003003003","APP交易数限制"),
    CODE_2003003004("2003003004","APP交易数限制下只能兑换测试专用券"),
    CODE_2003003005("2003003005","没有权限"),
    CODE_2003003006("2003003006","商品下架"),
    CODE_2003003007("2003003007","优惠券订单生成失败"),
    CODE_2003003008("2003003008","商品类型错误"),
    CODE_2003003009("2003003009","非兑吧付费商品"),
    CODE_2003003010("2003003010","非加钱购商品"),
    
    
    CODE_2003004001("2003004001","item 扣库存失败"),
    CODE_2003004002("2003004002","活动工具减奖项库存失败"),
    CODE_2003004003("2003004003","活动工具返还项库存失败"),
    CODE_2003004004("2003004004","预分配库存不存在"),
    CODE_2003004005("2003004005","预分配库存不足"),
    CODE_2003004006("2003004006","更新兑吧活动奖项预分配库存异常"),
    CODE_2003004007("2003004007","更新兑吧活动奖项预分配个数异常"),
    CODE_2003004008("2003004008","奖项不存在"),
    CODE_2003004009("2003004009","库存不足"),
    CODE_2003004010("2003004010","充值红包金额失败"),
    
    CODE_2003005001("2003005001","订单生成失败"),
    ;

    //错误码
    private String code;
    //错误信息
    private String msg;


    PrizeCenterErrorEnum(String code, String msg){
        this.code =code;
        this.msg =msg;
    }
    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
