package cn.com.duiba.prize.center.api.remoteservice.prize;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.params.prize.DuibaItemCheckPrizeParam;

/**
 * 奖项通用校验/商品通用校验
 *
 * Created by sunchangji on 2018/4/14.
 */
@AdvancedFeignClient
public interface RemoteItemCheckService {

    /**
     * 奖项商品(ItemKey)是否可用计算 包含以下的限制条件
     *  1.兑换项被禁用或者删除,AppItem和Item同时判断，有一处不符合，即拒绝
     *  2.有兑换限制的兑换项,限时(钟点时间段)、限量、日期限制
     *  用户兑换限制(每天/永久/每月/批次，AppItem/Item只有有一个符合，就拒绝)
     *  地域限制(白名单，名单内可中奖。黑名单，名单内不可中奖)
     *  3.兑换项没库存
     *  4.兑换项过期失效
     *  5.有APP兑换限制的只能中测试专用
     *
     * @param prizeParam
     * @return
     */
    Boolean validItemKeyCheck(DuibaItemCheckPrizeParam prizeParam);
}
