package cn.com.duiba.prize.center.api.enums;

/**
 * Created by sunchangji on 2018/4/14.
 */
public enum PrizeRedisKeyFactory {

    K001("CenterConfigDto"),
    K002("活动工具奖项"),
    K003("流量策略"),
    K004("活动工具多奖项限制每日模式"),
    K005("活动工具多奖项限制自定义模式"),
    K006("活动工具多奖项限制自定义模式本周期的结束时间"),
    K007("奖项限制自定义模式周期的结束时间"),
    K008("奖项限制的每日模式"),
    K009("奖项限制的自定义模式"),
    K010("ip缓存"),
    K011("活动奖品发放次数限制key"),
    K012("活动奖品发放次数限制到期日期key"),
    K013("活动奖品发放次数限制到期日期key"),
    K014("单个奖项配置"),
    K015("奖品详细信息"),
    K016("随机红包金额"),
    K068("插件发奖限制"),
    ;

    private String desc;

    PrizeRedisKeyFactory(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
		return desc;
	}

	/**
     * 活动web:activity-access-web
     */
    private static final String SPACE = "PRIZE";

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }
    
    /**
     * 拼接key前置
     */
    public String toStringNew() {
        return "AAW_" + super.toString() + "_";
    }
}
