package cn.com.duiba.prize.center.api.remoteservice.prize;

import java.util.List;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.prize.ActivityOptionsDto;
import cn.com.duiba.prize.center.api.dto.prize.PrizeDetailDto;

/**
 * ClassName:RemoteActivityOptionService<br/>
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2018/3/22  17:13
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteActivityOptionService {
	
	/**
	 * 
	 * findActivityOptions:根据opId,duibaId,activityType 查询活动配置的奖品信息 <br/>
	 * 
	 * @param opId
	 * @param duibaId
	 * @param activityType
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	List<ActivityOptionsDto> findActivityOptions(Long opId, Long duibaId,String activityType,Long appId) throws BizException;
	
	/**
	 * 
	 * getPrizeDetail:查询奖品信息 <br/>
	 * 
	 * @param appItemId
	 * @param itemId
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	PrizeDetailDto getPrizeDetail(Long appItemId, Long itemId, Long appId) throws BizException;
}