package cn.com.duiba.prize.center.api.remoteservice.encourage;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.encourage.EncourageCssDto;
import cn.com.duiba.prize.center.api.dto.encourage.EncourageInfoDto;
import cn.com.duiba.prize.center.api.params.encourage.EncourageParams;

/**
 * ClassName:RemoteEncourageBackendService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 激励广告配置信息
 * @date 创建时间：2018/12/22  17:10
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteEncourageBackendService {

	/**
	 * 查询奖项列表
	 * 
	 * @param params
	 * 
	 * @return
	 */
	Page<EncourageInfoDto> findAllEncourageInfo(EncourageParams params);

	/**
	 * 新增或者更新
	 * 
	 * @param info
	 * 
	 * @return
	 */
	Boolean saveOrUpdateEncourageInfo(EncourageInfoDto info);
	
	/**
	 * 删除
	 * 
	 * @param id
	 * 
	 * @return
	 */
	Boolean deleteEncourageInfo(Long id);
	
	/**
	 * 根据id 查询 激励广告配置
	 * 
	 * @param id
	 * 
	 * @return
	 */
	EncourageInfoDto findEncourageInfoById(Long id);
	
	/**
	 * 根据id 查询 激励广告配置css
	 * 
	 * @param id
	 * 
	 * @return
	 */
	EncourageCssDto findEncourageCssById(Long id);
	
	/**
	 * 新增或者更新css
	 * 
	 * @param info
	 * 
	 * @return
	 */
	Boolean saveOrUpdateEncourageCss(EncourageCssDto info);
}