package cn.com.duiba.projectx.api;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.projectx.api.dto.ProjectDto;
import cn.com.duiba.projectx.api.dto.ProjectSaveDto;

import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RemoteProjectsService
 * @Description: 项目信息相关服务
 * @date 2019/9/410:03
 */
@AdvancedFeignClient
public interface RemoteProjectsService {

    /**
     * 根据 项目ids查询 项目信息
     * @param projectIds 项目ids
     * @return
     */
    List<ProjectDto> findByProjectIds(List<String> projectIds);


    /**
     * 保存项目
     *
     * @param dto
     */
    void save(ProjectSaveDto dto) throws BizException;

}
