package cn.com.duiba.projectx.sdk.playway.assist;

import cn.com.duiba.projectx.sdk.UserRequestApi;

import java.util.List;
import java.util.Map;

public interface AssistUserRequestApi extends UserRequestApi{

    AssistUserContext getMyAssistContext();

    AssistUserContext getAssistContext(String userId);

    AssistItemContext getAssistItemContext(Long assistItemId);

    AssistItem find(Long assistItemId);
    /**
     * 发起一个助力
     * @param item
     * @return
     */
    Long createAssistItem(String item);

    /**
     * 更新助力物品的启用/停用状态
     * @param enable
     */
    boolean updateAssistItemStatus(Long assistItemId,boolean enable);

    /**
     * 将此次助力落库
     * @param assistItemId
     * @return
     */
    Long doAssist(Long assistItemId);

    /**
     * 查询我发起的助力清单
     * 根据时间倒序排列
     * @return
     */
    @Deprecated
    List<AssistItem> queryMyAssistItems();

    /**
     * 查询我今天的助力记录
     * 根据时间倒序排列
     * @return
     */
    @Deprecated
    List<AssistRecord> queryMyTodayDoAssist();

    /**
     * 查询我所有的助力记录
     * 根据时间倒序排列
     * @return
     */
    @Deprecated
    List<AssistRecord> queryMyTotalDoAssist();


    /**
     * 批量查询用户创建的助力物品清单
     * @param userIds
     * @return
     */
    Map<String,List<AssistItem>> batchQueryUserAssistItems(List<String> userIds);

    /**
     * 分页查询 创建的所有助力物品清单
     * 根据创建时间倒排序查询
     * 从prePageMinId开始往下查询size个物品
     *
     * @param prePageMinId 上一页最小id
     * @param size 希望返回的个数
     * @return
     */
    List<AssistItem> queryMore(long prePageMinId,int size);

    /**
     * 工具方法，将参数中disable的item剔除
     * @param list
     * @return
     */
    List<AssistItem> removeDisableItem(List<AssistItem> list);
}
