package cn.com.duiba.projectx.sdk.redacc;

import javax.validation.constraints.NotNull;

/**
 * 账户提现请求类
 * Created by xxd on 2019/02/27 下午2:14.
 */
public class AccountCashDrawsOuterRequest {

    private static final long serialVersionUID = 24826480767442076L;
    /**
     * 应用id
     */
    @NotNull
    private Long appId;
    /**
     * 用户id
     */
    @NotNull
    private Long consumerId;
    /**
     * 开发者用户id
     */
    private String partnerUserId;
    /**
     * 提现渠道
     */
    @NotNull
    private AccountCashDrawChannelEnum channelType;
    /**
     * 提现账号 兑换商品模式下传主订单id
     */
    private String channelAccount;
    /**
     * 提现金额 单位分
     */
    @NotNull
    private Long changeMoney;
    /**
     * 客户端ip
     */
    private String clientIp;
    /**
     * 客户端设备信息
     */
    private String clientUa;
    /**
     * 提现说明
     */
    private String drawsDescription;
    /**
     * 支付宝需要真实姓名
     */
    private String username;
    /**
     * 开发者id
     */
    private Long developerId;
    /**
     * 应用名称
     */
    private String appName;
    /**
     * 是否需要扣除开发者账户余额 默认不扣
     */
    @NotNull
    private Boolean deductDeveloperAmount = false;
    /**
     * 类型相关ID 默认为0
     */
    private Long relId = 0L;
    /**
     * 业务类型，1：红包广场
     **/
    private ActivityUniformityTypeEnum relType;
    /**
     * 商品名称
     */
    private String itemName;
    /**
     * 商品id
     */
    private Long itemId;
    /**
     * 针对 COMMON_CONSUMER 类型的提现 是否需要等待上游回调 来更新提现状态
     */
    private boolean interrupt = false;
    /**
     * 永辉定制传参数  格式 : {"activityId":1}  1为活动长id
     */
    private String customTransParam;
    /**
     * 提现环境。1：app，2：不限环境
     */
    private Integer withdrawEnvType;

    /**
     * 回调topic 非必传
     */
    private String callbackTopic;
    /**
     * 回调tag 非必传
     */
    private String callbackTag;
    /**
     * 回调透传参数
     */
    private String transfer;

    public String getCallbackTopic() {
        return callbackTopic;
    }

    public void setCallbackTopic(String callbackTopic) {
        this.callbackTopic = callbackTopic;
    }

    public String getCallbackTag() {
        return callbackTag;
    }

    public void setCallbackTag(String callbackTag) {
        this.callbackTag = callbackTag;
    }

    public String getTransfer() {
        return transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    public boolean isInterrupt() {
        return interrupt;
    }

    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getChannelAccount() {
        return channelAccount;
    }

    public void setChannelAccount(String channelAccount) {
        this.channelAccount = channelAccount;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getDrawsDescription() {
        return drawsDescription;
    }

    public void setDrawsDescription(String drawsDescription) {
        this.drawsDescription = drawsDescription;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getClientUa() {
        if (clientUa != null && clientUa.length() > 255) {
            //字段超过255长度，截取255个字符，防止数据库字段超长无法插入
            return clientUa.substring(0, 255);
        }
        return clientUa;
    }

    public void setClientUa(String clientUa) {
        this.clientUa = clientUa;
    }

    public Long getChangeMoney() {
        return changeMoney;
    }

    public void setChangeMoney(Long changeMoney) {
        this.changeMoney = changeMoney;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public AccountCashDrawChannelEnum getChannelType() {
        return channelType;
    }

    public void setChannelType(AccountCashDrawChannelEnum channelType) {
        this.channelType = channelType;
    }

    public Boolean getDeductDeveloperAmount() {
        return deductDeveloperAmount;
    }

    public void setDeductDeveloperAmount(Boolean deductDeveloperAmount) {
        this.deductDeveloperAmount = deductDeveloperAmount;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getRelId() {
        return relId;
    }

    public void setRelId(Long relId) {
        this.relId = relId;
    }

    public ActivityUniformityTypeEnum getRelType() {
        return relType;
    }

    public void setRelType(ActivityUniformityTypeEnum relType) {
        this.relType = relType;
    }

    public Integer getWithdrawEnvType() {
        return withdrawEnvType;
    }

    public void setWithdrawEnvType(Integer withdrawEnvType) {
        this.withdrawEnvType = withdrawEnvType;
    }

    public String getCustomTransParam() {
        return customTransParam;
    }

    public void setCustomTransParam(String customTransParam) {
        this.customTransParam = customTransParam;
    }
}
