package cn.com.duiba.projectx.sdk.redacc;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动自定义账户配置
 * Created by xiaoxuda on 2019/1/18.
 */
public class RedAccCustomData implements Serializable {

    private static final long serialVersionUID = 4700626059410769152L;
    /**
     * id
     **/
    private Long id;

    /**
     * 周期所属appId
     **/
    private Long appId;

    /**
     * 业务类型，1：红包广场
     **/
    private ActivityUniformityTypeEnum relType;

    /**
     * 业务ID
     **/
    private Long relId;

    /**
     * 奖励额度，单位：分
     **/
    private Long bonusLimit;

    /**
     * 提现限制类型，1：固定金额，2：最低门槛
     **/
    private WithdrawLimitTypeEnum withdrawLimitType;

    /**
     * 固定提现金额，单位：分
     **/
    private Long withdrawFixedCount;
    /**
     * 提现金额门槛，单位：分
     */
    private Long withdrawThreshold;

    /**
     * 提现次数限制类型，1：固定赠送，2：连续访问赠送
     **/
    private WithdrawTimeRewardTypeEnum timeRewardType;

    /**
     * 提现次数固定赠送值
     **/
    private Integer timeRewardFixedCount;

    /**
     * 提现次数连续访问赠送条件，连续访问天数
     **/
    private Integer timeRewardThreshold;

    //提现环境
    private Integer withdrawEnvType;

    /**
     * 周期开始时间
     **/
    private Date startTime;

    /**
     * 周期结束时间
     **/
    private Date endTime;

    /**
     * 记录创建时间
     **/
    private Date gmtCreate;

    /**
     * 记录修改时间
     **/
    private Date gmtModified;

    /**
     * 货币类型
     *
     * @see
     */
    private Integer currencyType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public ActivityUniformityTypeEnum getRelType() {
        return relType;
    }

    public void setRelType(ActivityUniformityTypeEnum relType) {
        this.relType = relType;
    }

    public Long getRelId() {
        return relId;
    }

    public void setRelId(Long relId) {
        this.relId = relId;
    }

    public Long getBonusLimit() {
        return bonusLimit;
    }

    public void setBonusLimit(Long bonusLimit) {
        this.bonusLimit = bonusLimit;
    }

    public WithdrawLimitTypeEnum getWithdrawLimitType() {
        return withdrawLimitType;
    }

    public void setWithdrawLimitType(WithdrawLimitTypeEnum withdrawLimitType) {
        this.withdrawLimitType = withdrawLimitType;
    }

    public Long getWithdrawFixedCount() {
        return withdrawFixedCount;
    }

    public void setWithdrawFixedCount(Long withdrawFixedCount) {
        this.withdrawFixedCount = withdrawFixedCount;
    }

    public Long getWithdrawThreshold() {
        return withdrawThreshold;
    }

    public void setWithdrawThreshold(Long withdrawThreshold) {
        this.withdrawThreshold = withdrawThreshold;
    }

    public WithdrawTimeRewardTypeEnum getTimeRewardType() {
        return timeRewardType;
    }

    public void setTimeRewardType(WithdrawTimeRewardTypeEnum timeRewardType) {
        this.timeRewardType = timeRewardType;
    }

    public Integer getTimeRewardFixedCount() {
        return timeRewardFixedCount;
    }

    public void setTimeRewardFixedCount(Integer timeRewardFixedCount) {
        this.timeRewardFixedCount = timeRewardFixedCount;
    }

    public Integer getTimeRewardThreshold() {
        return timeRewardThreshold;
    }

    public void setTimeRewardThreshold(Integer timeRewardThreshold) {
        this.timeRewardThreshold = timeRewardThreshold;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getCurrencyType() {
        return currencyType;
    }

    public void setCurrencyType(Integer currencyType) {
        this.currencyType = currencyType;
    }

    public Integer getWithdrawEnvType() {
        return withdrawEnvType;
    }

    public void setWithdrawEnvType(Integer withdrawEnvType) {
        this.withdrawEnvType = withdrawEnvType;
    }
}
