package cn.com.duiba.projectx.sdk.timerapis;

import cn.com.duiba.projectx.sdk.TimerApi;

public interface RankingTimerApi {
    /**
     * 对排行榜TopN进行发奖
     * @param topN
     * @param callback
     */
    public void sendPrize(String type,int topN,RankingTimerCallback callback);


    public abstract class RankingTimerCallback{
        protected TimerApi api;
        public RankingTimerCallback(TimerApi api){
            this.api=api;
        }
        /**
         * 逐个处理
         * @param index
         * @param userId
         * @return prizeId 会进行回填
         */
        public abstract String doSendPrize(int index,String userId);

        /**
         * 处理结束后回调通知，本次取TopN的数据进行处理，成功出列了successCount条数据
         * @param topN
         * @param successCount
         */
        public void onFinish(int topN,int successCount){

        }
    }

}
