package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.InnerBizCode;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.UserRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ActionNode.java , v 0.1 2020-01-21 10:07 上午 ZhouFeng Exp $
 */
public class ActionNode<I extends UserRequestApi> {

    /**
     * logger
     */
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    protected Component<I> component;

    protected Method action;

    public ActionNode(Component<I> component, String action) {
        this(component, component.getAction(action));
    }

    protected ActionNode(Component<I> component, Method action) {
        this.component = component;
        this.action = action;
    }

    @SuppressWarnings("unchecked")
    public Response<I> doAction(EventContext eventContext, UserRequestContext userRequestContext, I api) {
        try {
            return (Response<I>) action.invoke(component, eventContext, userRequestContext, api);
        } catch (Throwable t) {
            LOGGER.error("执行失败", t);
            LOGGER.warn("方法内部执行失败:{}.{}", this.getClass(), action.getName(), t.getCause());
            return Response.errorInterrupt(InnerBizCode.SYSTEM_ERROR);
        }
    }

    public String actionName() {
        return action.getName();
    }

    public Component<I> getComponent() {
        return component;
    }
}
