package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.UserRequestApi;

import java.lang.reflect.Method;

/**
 * 组件统一接口
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: Component.java , v 0.1 2020-01-21 9:53 上午 ElinZhou Exp $
 */
public interface Component<I extends UserRequestApi> extends EventContextType {

    Method getAction(String name);

    Method getRemoteAction(String name);

    String getId();

    /**
     * 执行前端action
     *
     * @param actionName
     * @param args
     * @return
     */
    Object doRemoteAction(String actionName, Object... args);
}
