package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.data.RankingConfigData;
import cn.com.duiba.projectx.sdk.playway.base.Ranking;

import java.util.List;

public interface RankingApi {
    /**
     * 更新排行榜分数
     * @param score 分值
     * @param high2low true:从高到低  false:从低到高
     */
    void updateRankingScore(String type,int score,boolean high2low);

    /**
     * 更新排行榜分数自动+1
     * 使用从高到低的排序
     */
    void updateRankingScoreByIncr(String type);

    /**
     * 清零我的分数
     * @param type
     */
    void clearRankingScore(String type);

    /**
     * 查询我的排名，返回null表明在1000名开外
     * @param type
     * @return
     */
    Integer getMyRank(String type);


    /**
     * 查询我的排行榜信息
     * @param type
     * @return
     */
    Ranking getMyRankInfo(String type);


    /**
     * 更新另一个人的排行榜数据
     *
     * 慎用，目前合理的一个使用方式是：在助力时，给助力发起方+1
     * @param somebodyUserId
     * @param type
     */
    void updateSomebodyRankingScoreByIncr(String somebodyUserId,String type);

    void updateSomebodyRankingScoreByIncr(String somebodyUserId,String type,int incr);

    void clearSomebodyRankingScore(String somebodyUserId,String type);

    Ranking getSomebodyRankInfo(String type,String sombodyUserId);

    /**
     * 导入排行榜配置数据
     * @param type 类型
     * @param rankingName 排行榜名称
     * @param manualSendPrize 是否手动发奖
     */
    void insertRankingConfig(String type, String rankingName,Boolean manualSendPrize);

    /**
     * 根据类型获取排行榜信息 如果没有返回null
     * @param type
     * @return
     */
    RankingConfigData getRankingConfigByType(String type);

    /**
     * 获取前几名的排行榜信息
     * @param type 排行榜id
     * @param topN 前几名
     *             不允许调用超过1000名的排名，会有性能问题
     * @return ranking 列表
     */
    List<Ranking> getTopN(String type,int topN);
}
