package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.data.UserRelation;

import java.util.List;

public interface UserRelationApi {

    /**
     * 添加一个关联用户
     * @param relationUserId
     * @return true:添加成功  false:添加不成功(已经存在)
     */
    boolean addRelationUser(String relationUserId,String extra);

    /**
     * 生成好友关系
     * @param userId userId
     * @param relationUserId relationUserId
     * @param extra extra
     * @return true:添加成功  false:添加不成功(已经存在)
     */
    boolean addRelation(String userId, String relationUserId, String extra);

    /**
     * 获取用户的好友列表
     * @param userId 用户id
     * @return 好友关系列表
     */
    List<UserRelation> findRelations(String userId);
}
