package cn.com.duiba.projectx.sdk.pay.ccb;

import cn.com.duiba.activity.custom.center.api.enums.ccb.SupplierEntityEnum;
import cn.com.duiba.projectx.sdk.pay.BasePayReq;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 建行支付请求
 *
 * @author fxr
 * @date 2020-6-30
 */
public class CcbChargeRequest extends BasePayReq {

    private static final long serialVersionUID = 7029253460204294941L;

    /**
     * 业务ID，业务方根据需要自定义，可不传
     */
    private String bizId;

    /**
     * 支付金额，单位为分
     */
    @NotNull(message = "支付金额必填")
    @Min(value = 1, message = "最少支付一分钱")
    private Integer amount;

    /**
     * 商户柜台代码
     * 区分钱支付到哪个供应商
     *
     * @see SupplierEntityEnum#getCode()
     */
    @NotNull(message = "商户柜台代码必填")
    private String posId;

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getPosId() {
        return posId;
    }

    public void setPosId(String posId) {
        this.posId = posId;
    }
}
