package cn.com.duiba.projectx.sdk.pay.ccb;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.dto.PayRecordDto;

import java.util.Map;

/**
 * 建行支付API
 *
 * @author fxr
 * @date 2020-6-30
 */
public interface CcbPayApi {

    /**
     * 创建支付
     *
     * @param request 请求
     * @return {@link CcbChargeResponse}
     */
    CcbChargeResponse createCharge(CcbChargeRequest request);


    /**
     * 建行支付结果通知
     *
     * @param map map
     * @return {@link CcbPayNotifyResp}
     * @throws BizRuntimeException 业务运行时异常
     */
    CcbPayNotifyResp orderNotify(Map<String, String> map);


    /**
     * 根据支付记录id查询支付记录
     *
     * @param id id
     * @return {@link PayRecordDto}
     */
    PayRecordDto findPayRecordById(Long id);


    /**
     * 查询用户最近一个进行中的订单
     *
     * @param projectId 项目id
     * @param userId    用户id
     * @return {@link PayRecordDto}
     */
    PayRecordDto findLastGoingOrder(String projectId, String userId);
}
