package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.wechat.MpUserinfoData;
import cn.com.duiba.projectx.sdk.wechat.SubscribeEnum;
import cn.com.duiba.projectx.sdk.wechat.WxAuthorizerData;
import cn.com.duiba.projectx.sdk.wechat.WxQrSceneSubscribeData;
import cn.com.duiba.projectx.sdk.wechat.WxReplyConfigData;
import cn.com.duiba.projectx.sdk.wechat.WxSceneIdGenParam;
import cn.com.duiba.projectx.sdk.wechat.WxSceneRecordData;
import cn.com.duiba.projectx.sdk.wechat.WxSubscribeEventData;

import java.util.List;

/**
 * 微信接口
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: WechatApi.java , v 0.1 2019-10-31 16:50 ZhouFeng Exp $
 */
public interface WechatApi {

    /**
     * 获取场景值
     * 分享时初始化分享数据，用于生成带参二维码
     *
     * @param param
     * @return
     */
    Long getSceneId(WxSceneIdGenParam param);


    /**
     * 插入微信事件回复内容配置
     *
     * @param data
     * @return
     */
    Long insert(WxReplyConfigData data);


    /**
     * 获取公众号下用户信息
     *
     * @param wechatAppId 微信公众号ID
     * @param openId      用户openID
     * @return 用户信息, 可能返回null
     */
    MpUserinfoData getUserinfo(String wechatAppId, String openId);


    /**
     * 获取公众号授权APP下用户信息
     *
     * @param consumerId 兑吧consumerID
     * @return 用户信息, 可能返回null
     */
    MpUserinfoData getUserInfo(Long consumerId);

    /**
     * 获取授权方信息
     *
     * @param duibaAppId 兑吧appId
     * @return
     */
    WxAuthorizerData getAuthorizerByAppId(Long duibaAppId);

    /**
     * 根据场景码获取实体类
     *
     * @param sceneId 场景值
     * @return 实体类
     */
    WxSceneRecordData getBySceneId(Long sceneId);

    /**
     * 查询用户绑定的openId
     * <p>
     * 该接口适用于从wechat授权登录的用户，在业务中绑定了手机号，然后用手机号作为uid进行免登
     *
     * @param consumerId 用户ID
     * @return openId 可能返回null
     */
    String getBindOpenId(Long consumerId);

    /**
     * 获取用户关注状态
     * @param consumerId
     * @return 关注状态，可能返回为null
     */
    SubscribeEnum getSubscribeStatus(Long consumerId);

    /**
     * 根据 openId 获取用户的信息，主要用于查询用户是通过哪一个带参二维码进入的
     * 如果 openId 为 null, 结果返回 null
     *
     * @param openId not null 用户openId
     * @return 用户信息
     */
    WxQrSceneSubscribeData getByOpenId(String openId);

    /**
     * 获取关注列表
     *
     * 该接口只会返回调用时刻的关注列表，用户取关后，会同步更新关注状态，该接口返回的数据会随着更新
     *
     * 例如：5 分钟前调用该接口，A 用户关注了，会在结果中返回；5 分钟后，A 用户取关，那么再次调用该接口， A用户不会在结果中

     * 如果参数中有一个为 null, 返回{@link java.util.Collections#emptyList()}
     *
     * @param appId      not null 应用ID
     * @param relationId not null 活动ID
     * @param sceneId    not null 带参二维码参数
     * @return 关注列表
     */
    List<WxQrSceneSubscribeData> getSubscribeList(Long appId, Long relationId, Long sceneId);

    /**
     * 获取所有扫描该场景值二维码的用户列表，结果中返回
     * A：firstScanStatus is {@link cn.com.duiba.projectx.sdk.wechat.SubscribeEnum#UNSUBSCRIBE}，
     * subscribeStatus is {@link cn.com.duiba.projectx.sdk.wechat.SubscribeEnum#SUBSCRIBE}
     * <p>
     * B：firstScanStatus is {@link cn.com.duiba.projectx.sdk.wechat.SubscribeEnum#UNSUBSCRIBE}，
     * subscribeStatus is {@link cn.com.duiba.projectx.sdk.wechat.SubscribeEnum#UNSUBSCRIBE}
     * <p>
     * C：firstScanStatus is {@link cn.com.duiba.projectx.sdk.wechat.SubscribeEnum#SUBSCRIBE}，
     * subscribeStatus is {@link cn.com.duiba.projectx.sdk.wechat.SubscribeEnum#SUBSCRIBE}
     * <p>
     * D：firstScanStatus is {@link cn.com.duiba.projectx.sdk.wechat.SubscribeEnum#SUBSCRIBE}，
     * subscribeStatus is {@link cn.com.duiba.projectx.sdk.wechat.SubscribeEnum#UNSUBSCRIBE}
     * 四个用户数据
     * <p>
     * A 和 B 表示是扫了这个码进行关注的，也就是这个{@code sceneId }吸引了两个用户关注，但是 B 用户后面又取消关注了。
     * <p>
     * C 和 D 表示之前都关注了公众号，但是是通过扫描带{@code sceneId }的二维码进入的，后来 D 用户取消关注了。
     * <p>
     * 如果参数中有一个为 null, 返回{@link java.util.Collections#emptyList()}
     *
     * @param appId      not null 应用ID
     * @param relationId not null 活动ID
     * @param sceneId    not null 带参二维码参数
     * @return 所有用户列表
     */
    List<WxQrSceneSubscribeData> getAllScanList(Long appId, Long relationId, Long sceneId);

    /**
     * 获取关注数量
     * 如果 appId 为 null, 返回 0
     *
     * @param appId      not null 应用ID
     * @param relationId nullable 活动ID
     * @param sceneId    nullable 带参二维码参数
     * @return 关注列表
     */
    Long getSubscribeCount(Long appId, Long relationId, Long sceneId);

    /**
     * 获取用户关注事件列表
     * @param consumerId 用户ID
     * @return 可能返回空 list
     */
    List<WxSubscribeEventData> getUserSubscribeEvents(Long consumerId);

    /**
     * 获取用户关注事件
     * @param consumerId 用户ID
     * @param subscribeStatus SubscribeEnum
     * @return 可能返回null
     */
    WxSubscribeEventData getUserSubscribeEvent(Long consumerId, Integer subscribeStatus);
}
