package cn.com.duiba.projectx.sdk.playway.pet;

import cn.com.duiba.projectx.sdk.StrategyResult;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author zhangruofan
 * @date 2020/08/19
 */
public class PetInfo implements Serializable {

    private static final long serialVersionUID = 3264517142696437356L;
    private Long id;

    private Integer petType;

    private String petName;

    private PetStatus petStatus;

    /**
     * 升级之后的信息
     */
    private UpgradeInfo upgradeInfo;

    private Integer petGrade;

    private Integer petExp;

    private List<UnclaimedOutput> outputList;

    public static class UpgradeInfo {
        /**
         * 如果升级有奖励且是发奖品的则列表有值
         */
        private List<StrategyResult> strategyResultList;

        private List<StatusPair> statusPairs;

        public List<StrategyResult> getStrategyResultList() {
            return strategyResultList;
        }

        public void setStrategyResultList(List<StrategyResult> strategyResultList) {
            this.strategyResultList = strategyResultList;
        }

        public List<StatusPair> getStatusPairs() {
            return statusPairs;
        }

        public void setStatusPairs(List<StatusPair> statusPairs) {
            this.statusPairs = statusPairs;
        }
    }

    public static class StatusPair {
        private PetProperties.Status prevStatus;

        private PetProperties.Status currentStatus;

        public PetProperties.Status getPrevStatus() {
            return prevStatus;
        }

        public void setPrevStatus(PetProperties.Status prevStatus) {
            this.prevStatus = prevStatus;
        }

        public PetProperties.Status getCurrentStatus() {
            return currentStatus;
        }

        public void setCurrentStatus(PetProperties.Status currentStatus) {
            this.currentStatus = currentStatus;
        }
    }
    /**
     * 宠物当前状态
     */
    public static class PetStatus {
        /**
         * 当前状态id
         */
        private Integer statusId;

        /**
         * 当前状态记录id，切换时使用
         */
        private Long statusRecordId;
        /**
         * 状态结束时间
         */
        private Date endDatetime;
        /**
         * 当前状态的产出配置
         * 是产出生成时的快照,和现在的配置可能不一样
         */
        private UnclaimedOutput output;

        public Integer getStatusId() {
            return statusId;
        }

        public void setStatusId(Integer statusId) {
            this.statusId = statusId;
        }

        public UnclaimedOutput getOutput() {
            return output;
        }

        public void setOutput(UnclaimedOutput output) {
            this.output = output;
        }

        public Long getStatusRecordId() {
            return statusRecordId;
        }

        public void setStatusRecordId(Long statusRecordId) {
            this.statusRecordId = statusRecordId;
        }

        public Date getEndDatetime() {
            return endDatetime;
        }

        public void setEndDatetime(Date endDatetime) {
            this.endDatetime = endDatetime;
        }
    }

    /**
     * 待领取的产出
     */
    public static class UnclaimedOutput {

        /**
         * sp_1
         */
        private String typeId;

        /**
         * 1 SP
         */
        private Integer type;

        private Integer quantity;

        private Date startDatetime;

        private Date endDatetime;

        private Integer upperLimit;

        private Integer rate;

        private Long recordId;

        public Date getStartDatetime() {
            return startDatetime;
        }

        public void setStartDatetime(Date startDatetime) {
            this.startDatetime = startDatetime;
        }

        public Date getEndDatetime() {
            return endDatetime;
        }

        public void setEndDatetime(Date endDatetime) {
            this.endDatetime = endDatetime;
        }

        public Integer getUpperLimit() {
            return upperLimit;
        }

        public void setUpperLimit(Integer upperLimit) {
            this.upperLimit = upperLimit;
        }

        public Integer getRate() {
            return rate;
        }

        public void setRate(Integer rate) {
            this.rate = rate;
        }

        public String getTypeId() {
            return typeId;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Long getRecordId() {
            return recordId;
        }

        public void setRecordId(Long recordId) {
            this.recordId = recordId;
        }

        public Integer getQuantity() {
            return quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }
    }

    public UpgradeInfo getUpgradeInfo() {
        return upgradeInfo;
    }

    public void setUpgradeInfo(UpgradeInfo upgradeInfo) {
        this.upgradeInfo = upgradeInfo;
    }

    public List<UnclaimedOutput> getOutputList() {
        return outputList;
    }

    public void setOutputList(List<UnclaimedOutput> outputList) {
        this.outputList = outputList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPetType() {
        return petType;
    }

    public void setPetType(Integer petType) {
        this.petType = petType;
    }

    public String getPetName() {
        return petName;
    }

    public void setPetName(String petName) {
        this.petName = petName;
    }

    public PetStatus getPetStatus() {
        return petStatus;
    }

    public void setPetStatus(PetStatus petStatus) {
        this.petStatus = petStatus;
    }

    public Integer getPetGrade() {
        return petGrade;
    }

    public void setPetGrade(Integer petGrade) {
        this.petGrade = petGrade;
    }

    public Integer getPetExp() {
        return petExp;
    }

    public void setPetExp(Integer petExp) {
        this.petExp = petExp;
    }
}
