package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.BizError;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ResultWrapper.java , v 0.1 2020-02-06 11:08 上午 ZhouFeng Exp $
 */
public class ResultWrapper {

    /**
     * 业务是否出现中断，如果出现中断了，说明业务没有正常执行完成
     */
    private boolean interrupt;

    /**
     * 业务错误码
     */
    private int errorCode;

    /**
     * 业务错误信息
     */
    private String errorMessage;

    /**
     * 原始数据
     */
    private Object raw;

    /**
     * 获取一个中断结果对象
     *
     * @param bizError
     * @return
     */
    public static ResultWrapper interrupt(BizError bizError) {
        ResultWrapper wrapper = new ResultWrapper();
        wrapper.interrupt = true;
        wrapper.errorCode = bizError.errorCode();
        wrapper.errorMessage = bizError.errorMessage();
        return wrapper;
    }


    /**
     * 获取一个正常业务执行的包装对象
     *
     * @param raw
     * @return
     */
    public static ResultWrapper of(Object raw) {
        ResultWrapper wrapper = new ResultWrapper();
        wrapper.interrupt = false;
        wrapper.raw = raw;
        return wrapper;
    }

    public boolean isInterrupt() {
        return interrupt;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public Object getRaw() {
        return raw;
    }
}
