/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.uitls;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClient.class);
    private static RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(5000).build();

    public static String doGet(String url) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpGet httpget = new HttpGet(url);
            httpget.setConfig(config);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                return string;
            }
        }
        catch (Exception e) {
            LOG.error("httpclient.doGet:{}" + e.getMessage(), (Object)url);
            throw e;
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                LOG.error("httpclient.close:" + e.getMessage());
            }
        }
        return null;
    }

    public static String doPost(String url, Map<String, String> params) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(config);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(list);
            httppost.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                return string;
            }
        }
        catch (Exception e) {
            LOG.error("httpclient.doPost:{}" + e.getMessage(), params);
            throw e;
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                LOG.error("httpclient.close:" + e.getMessage());
            }
        }
        return null;
    }
}

