package cn.com.duiba.projectx.sdk.playway.component;

import cn.com.duiba.projectx.sdk.StrategyResult;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.playway.component.bo.exchange.ExchangeAuthBo;
import cn.com.duiba.projectx.sdk.playway.component.bo.exchange.ExchangeLimitInfoBo;

/**
 * @program: projectx
 * @description: 组件化 - 兑换组件
 * @author: Simba
 * @create: 2021-02-19 17:18
 **/
public interface ExchangeComponentApi extends UserRequestApi {

    /**
     * 兑换条件及商品列表
     *
     * @param playwayId 玩法id
     * @return
     */
    ExchangeLimitInfoBo listExchangeLimit(String playwayId);

    /**
     * 玩法下指定规则id的权限
     *
     * @param playwayId 兑换策略ID
     * @param ruId      发奖规则id
     * @return 奖项
     */
    ExchangeAuthBo exchangeAuth(String playwayId, String ruId);

    /**
     * 使用兑换玩法id及指定发奖规则id兑换
     *
     * @param playwayId 玩法id
     * @param ruId      发奖规则id
     * @return 奖项
     */
    StrategyResult doExchange(String playwayId, String ruId);

}

