package cn.com.duiba.projectx.sdk.playway.component;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.playway.component.bo.inviteassist.*;
import cn.com.duiba.projectx.sdk.utils.PageList;

import java.util.List;

public interface InviteAssistComponentApi extends UserRequestApi {

    /**
     * 获取邀请码
     *
     * @param playwayId 玩法ID
     * @return
     */
    InviteBo getInviteCode(String playwayId);

    /**
     * 助力
     * <p>1. 获取分享者用户ID
     * <p>2. 不能为自己助力
     * <p>3. 助力条件判断
     *
     * @param playwayId 玩法ID
     * @param inviteCode 邀请码
     * @param extra 扩展值
     * @return
     */
    AssistBo doAssist(String playwayId, String inviteCode, String extra);

    /**
     * 查询今日的邀请记录
     * <p>时间倒序
     * <p>返回最近300条记录
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    List<InviteRecordBo> queryTodayInviteRecords(String playwayId, String userId);

    /**
     * 查询邀请记录
     * <p>时间倒序
     * <p>返回最近300条记录
     *
     * @param param 查询参数
     * @return
     */
    PageList<InviteRecordBo> queryInviteRecords(InviteAssistQueryParam param);

    /**
     * 查询今日的助力记录
     * <p>时间倒序
     * <p>返回最近300条记录
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    List<AssistRecordBo> queryTodayAssistRecords(String playwayId, String userId);

    /**
     * 查询助力记录
     * <p>时间倒序
     * <p>返回最近300条记录
     *
     * @param param 查询参数
     * @return
     */
    PageList<AssistRecordBo> queryAssistRecords(InviteAssistQueryParam param);

}
