package cn.com.duiba.projectx.sdk.playway.component;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.StrategyResult;
import cn.com.duiba.projectx.sdk.data.Option;
import cn.com.duiba.projectx.sdk.playway.base.PrizeStock;

import java.util.List;
import java.util.Map;

/**
 * @program: projectx
 * @description: 组件化 - 发奖组件
 * @author: Simba
 * @create: 2021-02-19 16:27
 **/
public interface SendPrizeComponentApi extends Api {

    /**
     * 使用发奖策略出奖
     *
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     */
    StrategyResult strategyPrize(String prizeStrategyId);

    /**
     * 使用发奖策略出奖
     * 可以指定一个用户进行策略发奖
     *
     * @param userId
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     */
    StrategyResult sendPrizeWithStrategy(String userId, String prizeStrategyId);

    /**
     * 给用户发放道具
     *
     * @param userId   userId
     * @param spId     道具ID
     * @param quantity 道具个数
     * @return 记录ID
     */
    Long giveStageProperty(String userId, String spId, int quantity);

    /**
     * 获取某个发奖策略下面的奖项列表
     *
     * @param strategyId 发奖策略id
     * @return list
     */
    List<Option> queryOptions(String strategyId);

    /**
     * 根据奖品id查询库存
     *
     * @param prizeId
     * @return
     */
    PrizeStock getPrizeStock(String prizeId);

    /**
     * 批量获取奖品库存信息
     *
     * @param ids prize ids
     * @return prize stock list
     */
    List<PrizeStock> listPrizeStock(List<String> ids);

    /**
     * 查询某人部分道具的数量
     *
     * @param userId 需要查询的用户
     * @param spIds  道具id集合
     * @return
     */
    Map<String, Long> getSomebodySomeStageProperty(String userId, List<String> spIds);

    /**
     * 消耗某个用户的道具
     *
     * @param userId   userId
     * @param spId     spId
     * @param quantity 数量
     * @return 消耗是否成功
     */
    Boolean consumeStageProperty(String userId, String spId, int quantity);


}

