package cn.com.duiba.projectx.sdk.playway.component;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.playway.component.bo.share.ShareBo;
import cn.com.duiba.projectx.sdk.playway.component.bo.share.ShareQueryBo;

public interface ShareComponentApi extends UserRequestApi {

    /**
     * 分享
     * <p>1.不在组件开始和结束时间内, 抛出BizRuntimeException
     * <p>2.获取邀请码
     * <p>3.获取访问次数, 加1保存.
     * <p>4.满足条件后, 发奖.
     *
     * @param playwayId 玩法ID
     * @return
     */
    ShareBo doShare(String playwayId);

    /**
     * 分享
     * <p>1.不在组件开始和结束时间内, 抛出BizRuntimeException
     * <p>2.获取邀请码
     * <p>3.获取访问次数, 加1保存.
     * <p>4.满足条件后, 发奖.
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    ShareBo doShare(String playwayId, String userId);

    /**
     * 查询当前周期内的次数
     *
     * @param playwayId 玩法ID
     * @return
     */
    ShareQueryBo queryCount(String playwayId);

    /**
     * 查询当前周期内的次数
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    ShareQueryBo queryCount(String playwayId, String userId);

}
