package cn.com.duiba.projectx.sdk.playway.component.playwayinstance;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.playway.base.PlaywayCommonConfig;
import cn.com.duiba.projectx.sdk.playway.component.ExchangeComponentApi;
import cn.com.duiba.projectx.sdk.playway.component.vo.exchange.ExchangeAuthVo;
import cn.com.duiba.projectx.sdk.playway.component.vo.exchange.ExchangeLimitInfoVo;
import cn.com.duiba.projectx.sdk.playway.component.vo.exchange.ExchangeResultVo;

/**
 * @program: projectx
 * @description: 组件化 - 兑换组件玩法
 * @author: Simba
 * @create: 2021-02-23 18:56
 **/
public abstract class ExchangePlaywayInstance {

    public void config(ExchangePlaywayInstance.ExchangeConfig config) {

    }

    /**
     * 查询该兑换组件玩法及商品列表
     * {@link ExchangeComponentApi#listExchangeLimit(String)}
     */
    public abstract ExchangeLimitInfoVo listExchangeLimit(UserRequestContext context, ExchangeComponentApi api);

    /**
     * 该玩法下指定商品的兑换权限
     * {@link ExchangeComponentApi#exchangeAuth(String, String)}
     */
    public abstract ExchangeAuthVo exchangeAuth(String ruId, UserRequestContext context, ExchangeComponentApi api);

    /**
     * 使用兑换玩法id兑换
     * {@link ExchangeComponentApi#doExchange(String, String)}
     */
    public abstract ExchangeResultVo doExchange(String ruId, UserRequestContext context, ExchangeComponentApi api);

    public static class ExchangeConfig extends PlaywayCommonConfig<ExchangePlaywayInstance.ExchangeConfig> {

    }
}