package cn.com.duiba.projectx.sdk.playway.component.playwayinstance;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.playway.base.PlaywayCommonConfig;
import cn.com.duiba.projectx.sdk.playway.component.InviteAssistComponentApi;
import cn.com.duiba.projectx.sdk.playway.component.bo.inviteassist.*;
import cn.com.duiba.projectx.sdk.utils.PageList;

/**
 * 邀请助力玩法
 */
public abstract class InviteAssistPlaywayInstance {

    /**
     * @param config
     */
    public void config(InviteAssistPlaywayInstance.Config config){

    }

    /**
     * 分享
     *  请调用 api.getInviteCode()
     * @param context
     * @param api
     * @return
     */
    public abstract InviteBo getInviteCode(UserRequestContext context, InviteAssistComponentApi api);

    /**
     * 分享
     *  请调用 api.doAssist()
     * @param context
     * @param api
     * @return
     */
    public abstract AssistBo doAssist(AssistParam param, UserRequestContext context, InviteAssistComponentApi api);

    /**
     * 分享查询
     *  请调用 api.queryTodayInviteRecords() or api.queryAllInviteRecords()
     * @param context
     * @param api
     * @return
     */
    public abstract PageList<InviteRecordBo> queryInviteRecords(InviteAssistQueryParam param, UserRequestContext context, InviteAssistComponentApi api);

    /**
     * 分享查询
     *  请调用 api.queryTodayAssistRecords() or api.queryAllAssistRecords()
     * @param context
     * @param api
     * @return
     */
    public abstract PageList<AssistRecordBo> queryAssistRecords(InviteAssistQueryParam param, UserRequestContext context, InviteAssistComponentApi api);

    public static class Config extends PlaywayCommonConfig<Config> {

    }
}
