package cn.com.duiba.projectx.sdk;

import java.util.Map;

/**
 * 星速台项目上下文
 * 所有扩展的内部上下文都需要继承该接口
 * @author zhangruofan
 * @date 2020/04/21
 */
public interface ProjectContext {
    /**
     * get context value by key
     * @param key context key
     * @return context value
     */
    Object getValue(String key);

    /**
     * set context value
     * @param key context key
     * @param value context value
     */
    void setValue(String key, Object value);

    /**
     * get project id
     * @return project id
     */
    String getProjectId();

    /**
     * get play way id
     * @return play way id
     */
    String getPlaywayId();

    /**
     * get action id
     * @return action id
     */
    String getActionId();

    /**
     * get send prize context
     * @return send prize context
     */
    SendPrizeContext getSendPrizeContext();

    /**
     * getAttribute
     * @return
     */
    Map<String, Object> getAttribute();
}
