package cn.com.duiba.projectx.sdk.playway.component;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.playway.component.bo.fixedtime.FixedTimeBo;

public interface FixedTimeComponentApi extends UserRequestApi {

    /**
     * 查询场次
     * <p>当前时间是否在场次内
     *
     * @param playwayId 玩法ID
     * @return
     */
    FixedTimeBo query(String playwayId);

    /**
     * 查询场次并发奖
     * <p>1.当前时间是否在场次内
     * <p>2.满足发奖条件,发放对应奖励
     *
     * @param playwayId 玩法ID
     * @return
     */
    FixedTimeBo queryAndAwardPrize(String playwayId);
}
