package cn.com.duiba.projectx.sdk.playway.scoring;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.playway.base.PlaywayCommonConfig;

/**
 * 计分玩法的自定义功能实现
 */
public abstract class ScoringPlaywayInstance{


    public void config(ScoringConfig config){

    }

    /**
     * 如允许开始游戏，请调用 api.getCurrentRecordId() 获得参与游戏的startId，并将startId返回给前端
     * @param context
     * @param api
     * @return
     */
    public abstract Object start(UserRequestContext context,ScoringUserRequestApi api);

    /**
     * 默认不允许多次提交，如需开放，请配置 ScoringConfig
     * @param startRecord
     * @param score  最高分值：9999999  ，超过将会自动拒绝
     * @param context
     * @param api
     * @return Object
     *      Boolean:true 表明允许提交，将自动进行提交动作
     *
     */
    public abstract Object submit(StartRecord startRecord, int score, UserRequestContext context,
                                  ScoringUserRequestApi api);

    public static class ScoringConfig extends PlaywayCommonConfig<ScoringConfig>{
        /**
         * 是否允许一次游戏多次提交
         * 默认不允许多次提交，当多次提交时会自动拒绝
         *
         * 如果开启允许多次提交，第N次提交的合法性，必须配合自定义代码来验证
         */
        protected boolean allowMultiSubmit=false;


        public ScoringConfig setAllowMultiSubmit(boolean bool){
            this.allowMultiSubmit=bool;
            return this;
        }

        public boolean isAllowMultiSubmit() {
            return allowMultiSubmit;
        }
    }

}
