package cn.com.duiba.projectx.sdk.timerapis;

import cn.com.duiba.projectx.sdk.playway.luckycode.Luckycode;

import java.util.Date;
import java.util.List;

public interface LuckycodeTimerApi {

    /**
     * 精确查询匹配code的记录
     * @param code
     * @return
     */
    List<Luckycode> queryAllByLuckycode(String periodical, String code);

    /**
     * 前缀匹配查询记录
     * @param prefixCode
     * @return
     */
    List<Luckycode> queryAllByLuckycodePrefix(String periodical,String prefixCode);

    /**
     * 更新记录
     * 参数为null表示不更新此字段
     *
     * 数据库中已经有值的字段，再次更新将抛出异常，拒绝二次更新(防止重复发奖)
     * @param id
     * @param prizeDegree
     * @param prizeId
     * @param sendPrizeTime
     */
    void updatePrizeContent(Long id, String prizeDegree, String prizeId, Date sendPrizeTime);

    /**
     * 根据奖项查询记录
     *
     * @param prizeDegree 奖项
     * @return
     */
    List<Luckycode> queryByPrizeDegree(String periodical, String prizeDegree);
}
