package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.data.AdministrativeDivisionData;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2020/02/14
 */
public interface AdministrativeDivisionApi {
    /**
     * 根据中国行政区号查行政区域名称（支持5级）
     * //行政级别 1 省，州 2 市 3 县，区  4 乡镇，街道
     *
     * @param adcode 行政区域编码 支持 2位 4位 6位 9位
     * @return 返回adcode对应的 行政区域降序编排
     * <p>
     * EX: 33,3300,330000 -> [浙江]
     * EX: 330100 -> [浙江,杭州]
     * EX: 330106 -> [浙江,杭州,西湖]
     * EX: 330106007 -> [浙江,杭州,西湖,古荡]
     * <p>
     * 如 adcode 存在错误，查询结果会遍历到错误区域前一级
     * <p>
     * EX: 330106999 -> [浙江,杭州,西湖]  999没有对应的区域
     */
    List<AdministrativeDivisionData> findAdministrativeDivisionByCode(String adcode);

    /**
     * 获取省级行政区域列表(可用于地址联动加载)
     *
     * @return 省级区域，包括 直辖市，港澳台
     */
    List<AdministrativeDivisionData> findRegionDivision();

    /**
     * 根据父级行政编号查询下一级行政区域列表(可用于地址联动加载)
     *
     * @param adcode 父级行政区域编码 支持 2位 4位 6位 9位
     * @return 子级行政单位列表
     */
    List<AdministrativeDivisionData> findAdministrativeDivisionByParentAdCode(String adcode);

    /**
     * 检索对应的行政区划的区划编号
     * @param adNames 按 省 市 区 镇 的顺序传入，最多4级，adNames的Size可以随意 EX：省 市
     * @return 行政区划的编码 省 市 区 为6位 乡镇为 9位
     * 传入的行政链路允许出现断层，GEO会做磁力关联
     * EX:浙江，西湖
     */
    String findAdcode(List<String> adNames);
}
