package cn.com.duiba.projectx.sdk;


import cn.com.duiba.projectx.sdk.data.CreditsParamData;
import cn.com.duiba.projectx.sdk.data.Option;
import cn.com.duiba.projectx.sdk.timerapis.ComponentTimerApi;
import cn.com.duiba.projectx.sdk.utils.DuibaApi;
import cn.com.duiba.projectx.sdk.utils.ExpireTime;
import cn.com.duiba.projectx.sdk.utils.Field;
import cn.com.duiba.projectx.sdk.utils.HttpHelper;
import cn.com.duiba.projectx.sdk.utils.KeyValueApi;
import cn.com.duiba.projectx.sdk.utils.NotifyApi;
import cn.com.duiba.projectx.sdk.utils.QueryTable;
import cn.com.duiba.projectx.sdk.utils.UserRelationApi;

import java.security.KeyStore;
import java.util.Date;
import java.util.List;

/**
 * 定时任务作用域下的API
 * @author xuhengfei
 *
 */
public interface TimerApi {
    /**
     * 直接发奖，不通过发奖规则进行发奖
     *
     * @param strategyId
     * @param userId
     * @param prizeId
     * @return
     * @deprecated 使用TimerApi.sendPrize()方法
     */
    @Deprecated
    boolean sendPrizeWithDirect(String strategyId,String userId,String prizeId);

    /**
     * 直接发奖，不通过发奖规则进行发奖
     * @param strategyId 策略id
     * @param userId userId
     * @param prizeId prizeId
     * @return SendPrizeResult
     */
    SendPrizeResult sendPrize(String strategyId, String userId, String prizeId);

    /**
     * 直接给用户增加积分
     * 没有用户中奖记录
     * 如果发放失败则抛运行时异常
     * @param userId 用户id 不能为空
     * @param quantity 积分数量 不能为空
     * @param description 描述，需要定制时通过该参数, 可以为空
     */
    void sendCreditsPrize(String userId, Long quantity, String description);

    /**
     * 获取运营配置的变量Integer
     *
     * @param key 配置项Variable
     * @return 变量对应的int值
     */
    Integer getIntVariable(String key);

    /**
     * 获取运营配置变量String
     *
     * @param key 配置项Variable
     * @return 变量对应的String值
     */
    String getStringVariable(String key);

    /**
     * 获取kv记录
     *
     * @param key
     * @return
     * @deprecated {@link TimerApi#getKeyValueApi()} {@link KeyValueApi#get(String)}
     */
    @Deprecated
    String getKvStringData(String key);

    /**
     * 添加/更新KV记录
     *
     * @param key
     * @param value
     * @param expireTime
     * @return
     * @deprecated {@link TimerApi#getKeyValueApi()} {@link KeyValueApi#set(String, String, ExpireTime)}
     */
    @Deprecated
    boolean putKvStringData(String key, String value, Date expireTime);


    /**
     * 增加/减少数值
     *
     * @param key
     * @param offset 增量
     * @param expire 失效时间
     * @return 变更后的数值
     * @deprecated {@link TimerApi#getKeyValueApi()} {@link KeyValueApi#increase(String, long, ExpireTime)}
     */
    @Deprecated
    long increase(String key, long offset, Date expire);


    /**
     * 获取kv中的数值
     *
     * @param key
     * @return 当值不存在时返回null，存在时返回实际数值
     * @deprecated {@link TimerApi#getKeyValueApi()} {@link KeyValueApi#getLong(String)}
     */
    @Deprecated
    Long getKvLong(String key);


    /**
     * 给用户发放道具
     * @param userId userId
     * @param spId     道具ID
     * @param quantity 道具个数
     * @return 记录ID
     */
    Long giveStageProperty(String userId, String spId, int quantity);

    /**
     * 消耗用户道具
     * @param userId
     * @param spId
     * @param quantity
     * @return
     */
    Boolean consumeStageProperty(String userId, String spId, int quantity);

    Long getSomebodyStageProperty(String userId, String spId);

    /**
     * 获取白名单用户list
     *
     * @param groupId 白名单分组ID
     * @return
     */
    List<String> getWhiteUserIdsByGroup(String groupId);

    /**
     * 获取一个QueryTable实例
     *
     * @param group 数据分组
     * @param clazz 映射类型
     * @param <T>
     * @return
     */
    <T extends Field> QueryTable<T> getTable(String group, Class<T> clazz);

    /**
     * 获取某个发奖策略下的所有奖项
     * @param strategyId 发奖策略id
     * @return 奖项列表
     */
    List<Option> queryOptions(String strategyId);

    /**
     * 获取一个http请求实例,不同project之间相互隔离
     *
     * @return
     */
    HttpHelper getHttpHelper();

    /**
     * 获取一个https请求实例
     *
     * @param name     实例的名称，不同实例间隔离
     * @param keyStore 证书
     * @return
     */
    HttpHelper getHttpHelper(String name, KeyStore keyStore);

    /**
     * 获取通知api
     *
     * @return
     */
    NotifyApi getNotifyApi();

    /**
     * 获取key-value存储功能API
     *
     * @return
     */
    KeyValueApi getKeyValueApi();

    DuibaApi getDuibaApi();

    UserRelationApi getUserRelationApi();

    /**
     * 扣减拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口扣减拖管积分
     * @param creditsParamData
     * @return
     */
    Boolean subTrustCredits(CreditsParamData creditsParamData);

    /**
     * 增加拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口增加拖管积分
     * @param creditsParamData
     * @return
     */
    Boolean addTrustCredits(CreditsParamData creditsParamData);

    /**
     * 查询拖管积分
     * 注意：此方法只针对兑吧拖管积分
     * 调credits-center接口查询拖管积分
     * @param userId
     * @return
     */
    Long queryTrustCreditsByConsumerId(String userId);

    /**
     * 返回projectId
     * @return
     */
    String getProjectId();

    /**
     * 组件Api
     * @return
     */
    ComponentTimerApi getComponentTimerApi();
}
