package cn.com.duiba.projectx.sdk.playwayv2.signin;

import cn.com.duiba.projectx.sdk.BizError;

public enum SigninErrors implements BizError {

    EXIST_SIGN(510001, "已经签到"),
    EXTRA_GT_1024(510002, "扩展参数长度大于1024"),


    ;

    private int errorCode;
    private String errorMessage;

    SigninErrors(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public int errorCode() {
        return errorCode;
    }

    @Override
    public String errorMessage() {
        return errorMessage;
    }
}
