package cn.com.duiba.projectx.sdk.repeatable.mvp;

import cn.com.duiba.projectx.sdk.annotation.CustomRequestAction;
import cn.com.duiba.projectx.sdk.playway.InitializationContext;
import cn.com.duiba.projectx.sdk.playway.PlaywayInitialization;
import cn.com.duiba.projectx.sdk.playway.scoring.ScoringPlaywayInstance;
import cn.com.duiba.projectx.sdk.repeatable.utils.ConfigUtils;

import java.util.Map;

/**
 * 抽象计分玩法MVP
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: AbstractScoringInstanceMvp.java , v 0.1 2020-03-02 9:29 下午 ZhouFeng Exp $
 */
public abstract class AbstractScoringInstanceMvp extends ScoringPlaywayInstance implements Mvp, PlaywayInitialization {

    private InitializationContext initializationContext;

    private Map<String, String> configMap;

    @Override
    public void init(InitializationContext context) {
        this.initializationContext = context;
        configMap = ConfigUtils.merge(initializationContext.getOperationConfig(),
                initializationContext.getDevProperties());
        init();
        populate(this, configMap);
    }

    @Override
    public InitializationContext getInitializationContext() {
        return initializationContext;
    }

    @CustomRequestAction(id = "coop_config", name = "获取配置")
    public Object config() {
        // 返回所有的配置
        return configMap;
    }

    @CustomRequestAction(id = "coop_components", name = "获取已配置组件")
    public Object components() {
        return currentComponents();
    }

}
