package cn.com.duiba.projectx.sdk.timerapis;

import cn.com.duiba.projectx.sdk.TimerApi;
import cn.com.duiba.projectx.sdk.data.SigninResp;
import com.alibaba.fastjson.JSONObject;

import java.util.Date;
import java.util.List;

public interface SigninTimerApi extends TimerApi {
    /**
     * 查询签到配置
     *
     * @param playwayId 玩法ID
     * @return
     */
    JSONObject config(String playwayId);

    /**
     * 用户签到
     *  有一个前置判断,今天没有签到
     *
     * @param playwayId 玩法ID
     * @param extra 扩展参数,长度小于1024
     * @return
     *  true=签到成功
     *  false=签到失败
     */
    boolean doSign(String playwayId, String userId, String extra);

    /**
     * 用户补签签到
     *  只增加签到记录,不做其他操作
     *
     * @param playwayId 玩法ID
     * @param datetime 补签时间
     * @param extra 扩展参数,长度小于1024
     * @return
     *  true=签到成功
     *  false=签到失败
     */
    boolean reSign(String playwayId, String userId, Date datetime, String extra);

    /**
     * 发放奖品
     *  当该玩法已配置奖励, 根据配置发放对应的奖品.
     *
     * @param playwayId 玩法ID
     * @return
     *  true=奖品发放成功
     *  false=奖品发放失败,  包括未配置奖励
     */
    boolean sendPrize(String playwayId, String userId);

    /**
     * 是否签到
     * @param playwayId 玩法ID
     * @param datetime 签到时间
     * @return
     *  true=已签到
     *  false=未签到
     */
    boolean isSign(String playwayId, String userId, Date datetime);

    /**
     * 查询本周期内的 连续/累计签到天数
     *
     * @param playwayId 玩法ID
     * @return
     */
    Integer getSignDays(String playwayId, String userId);

    /**
     * 查询签到数据
     *
     * @param playwayId 玩法ID
     * @param startDatetime 开始时间
     * @param endDatetime 结束时间
     * @return
     */
    List<SigninResp> queryRecords(String playwayId, String userId, Date startDatetime, Date endDatetime);
}
