package cn.com.duiba.projectx.sdk.repeatable;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: EventKeyWrapper.java , v 0.1 2020-01-31 11:26 下午 ZhouFeng Exp $
 */
public class EventKeyWrapper {

    private String key;

    private Class<? extends EventContextType> clazz;

    private EventKeyWrapper() {
    }

    public static EventKeyWrapper of(Class<? extends EventContextType> clazz, String key) {
        EventKeyWrapper wrapper = new EventKeyWrapper();

        wrapper.clazz = clazz;
        wrapper.key = key;
        return wrapper;
    }

    public String getKey() {
        return key;
    }

    public String innerKey() {
        return clazz.getName() + "." + key;
    }

    public String simpleKey() {
        return clazz.getSimpleName() + "." + key;
    }

    @Override
    public int hashCode() {
        return innerKey().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EventKeyWrapper)) {
            return false;
        }
        return innerKey().equals(((EventKeyWrapper) obj).innerKey());
    }
}
