package cn.com.duiba.projectx.sdk.component.team;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.team.dto.TeamInfoResult;
import cn.com.duiba.projectx.sdk.component.team.dto.TeamJoinResult;
import cn.com.duiba.projectx.sdk.component.team.dto.TeamMemberResult;
import cn.com.duiba.projectx.sdk.component.team.dto.TeamQueryParam;
import cn.com.duiba.projectx.sdk.component.team.dto.TeamQueryResult;
import cn.com.duiba.projectx.sdk.component.team.dto.TeamResult;
import cn.com.duiba.projectx.sdk.utils.PageList;

import java.util.List;
import java.util.Map;

public interface TeamApi extends UserRequestApi {

    /**
     * 队伍名称是否存在
     * @param teamType 必传
     * @param teamName 必传
     * @return
     */
    boolean existTeamName(String teamType, String teamName);

    /**
     * 更新队伍名称
     * @param teamType 必传
     * @param teamName 必传
     * @return
     */
    boolean updateTeamName(String playwayId, String teamType, String teamName);

    /**
     * 根据code列表查询队伍列表
     * @param playwayId
     * @param codeList
     * @return
     */
    Map<String, TeamInfoResult> findByTeamCodeList(String playwayId, List<String> codeList);

    /**
     * 查询队伍列表
     *  队伍分数倒序
     * @param param
     * @return
     */
    PageList<TeamInfoResult> findTeams(TeamQueryParam param);

    /**
     * 查询队员列表
     *  队员分数倒序
     * @param playwayId
     * @param teamCode
     * @return
     */
    List<TeamMemberResult> findTeamMembers(String playwayId, String teamCode);

    /**
     * 查询我的队伍信息
     * @param playwayId
     * @param userId
     * @return
     */
    TeamQueryResult query(String playwayId, String userId);

    /**
     * 查询队伍信息
     * @param playwayId 必传
     * @param userId 必传
     * @return
     */
    TeamInfoResult getTeamByUserId(String playwayId, String userId);

    /**
     * 查询的队伍Code
     * @param playwayId 必传
     * @param userId 必传
     * @param teamType 必传
     * @return
     */
    TeamResult getTeamCode(String playwayId, String userId, String teamType);

    /**
     * 查询的队伍Code
     * @param playwayId 必传
     * @param userId 必传
     * @param teamType 必传
     * @param teamName
     * @param extra
     * @return
     */
    TeamResult getTeamCode(String playwayId, String userId, String teamType, String teamName, String extra);

    /**
     * 加入队伍
     *
     * 但所有队员都退出该队伍, 第一个加入队伍的, 队长
     *
     * @param playwayId
     * @param userId
     * @param teamCode 队伍Code
     * @return
     */
    TeamJoinResult join(String playwayId, String userId, String teamCode);

    /**
     * 加入队伍
     *
     * 但所有队员都退出该队伍, 第一个加入队伍的, 队长
     *
     * @param playwayId
     * @param userId
     * @param teamCode 队伍Code
     * @param extra 扩展值
     * @return
     */
    TeamJoinResult join(String playwayId, String userId, String teamCode, String extra);

    /**
     * 退出队伍
     * @param playwayId
     * @param userId
     * @return
     */
    boolean quit(String playwayId, String userId);

    /**
     * 解散队伍
     * @param playwayId
     * @param teamCode 队伍Code
     * @return
     */
    boolean disband(String playwayId, String teamCode);

    /**
     * 设为队长
     * @param playwayId
     * @param userId
     * @param teamCode 队伍Code
     * @return
     *  该 userId 已经是队长 = false
     */
    boolean setLeader(String playwayId, String userId, String teamCode);

    /**
     * 提交分数
     * @param playwayId
     * @param userId
     * @param score 分数
     * @return
     */
    boolean submit(String playwayId, String userId, int score);

}
