package cn.com.duiba.projectx.sdk.demo;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.annotation.CustomRequestAction;
import cn.com.duiba.projectx.sdk.annotation.UserConcurrentLock;
import cn.com.duiba.projectx.sdk.playway.JoinUserRequestApi;
import cn.com.duiba.projectx.sdk.playway.join.JoinPlaywayInstance;
import cn.com.duiba.projectx.sdk.template.DistributedLock;
import org.springframework.beans.factory.annotation.Autowired;

public class JoinDemo extends JoinPlaywayInstance{

    @Autowired
    private JoinUserRequestApi userRequestApi;

    @Override
    public void config(JoinConfig config) {
        config.setUserlockEnable(true);
    }

    @Override
    public Object doJoin(UserRequestContext context, JoinUserRequestApi userRequestApi) {

        //方法一：手动上锁，在锁范围内处理业务逻辑
        DistributedLock lock = userRequestApi.newLock("key", 5);
        try {
            if (lock.tryLock()) {
                //业务逻辑
                Integer result1 = doSomething();
            }
        } finally {
            lock.unlock();
        }

        return "ok";
    }
    @CustomRequestAction(id="query",name = "查询")
    @UserConcurrentLock(expireSeconds = 5)
    public Object query(UserRequestContext context,JoinUserRequestApi api){
        return null;
    }


    private Integer doSomething() {
        return 1;
    }
}
