package cn.com.duiba.projectx.sdk.component.rank;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.playway.base.Ranking;
import cn.com.duiba.projectx.sdk.playway.base.RankingUserPrizeRecord;

import java.util.List;

public interface RankApi extends UserRequestApi {

    /**
     * 获取前几名的排行榜信息
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     * @param topN          前几名
     *                      不允许调用超过3000名的排名，会有性能问题
     * @return ranking 列表
     */
    List<Ranking> getTopN(String rankPlaywayId, int topN);

    /**
     * 新排行榜，更改底层maxScoreOrder生成规则
     *  ⚠️ 接口内部不作单用户并发处理，由业务方决定
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     * @param userId
     * @param score
     * @return
     */
    void submit(String rankPlaywayId, String userId, int score);

    /**
     * 更新排行榜分数, 接口废弃
     *
     * @param score 分值
     * @deprecated 请使用 {@link cn.com.duiba.projectx.sdk.component.rank.RankApi#updateRankingScore(java.lang.String, java.lang.String, int)}
     */
    @Deprecated
    void updateRankScore(String rankPlaywayId, String userId, String rankType, int score);

    /**
     * 更新排行榜分数
     *  ⚠️ 接口内部不作单用户并发处理，由业务方决定
     *
     * @param score 分值
     */
    void updateRankingScore(String rankPlaywayId, String userId, int score);

    /**
     * 更新排行榜分数自动+1
     * 使用从高到低的排序
     *  ⚠️ 接口内部不作单用户并发处理，由业务方决定
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     */
    void updateRankingScoreByIncr(String rankPlaywayId, String userId, int score);

    /**
     * 替换排行榜分数 - 针对新榜
     * 使用从高到低的排序
     *  ⚠️ 接口内部不作单用户并发处理，由业务方决定
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     */
    void replaceRankingScore(String rankPlaywayId, String userId, int score);

    /**
     * 清零我的分数 - 针对新榜
     *  ⚠️ 接口内部不作单用户并发处理，由业务方决定
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     */
    void clearRankingScore(String rankPlaywayId, String userId);

    /**
     * 查询我的排名，返回null表明在3000名开外
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     * @return
     */
    Integer getMyRank(String rankPlaywayId);

    /**
     * 查询我的排行榜信息
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     * @return
     */
    Ranking getMyRankInfo(String rankPlaywayId);

    /**
     * 获取上期排行榜当前用户信息
     * 排行榜已结束-返回最后一期
     * 排行榜未结束-返回上一期
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     * @return
     */
    RankingUserPrizeRecord getPreMyRank(String rankPlaywayId);

    /**
     * 获取上期排行榜当前用户信息
     * 排行榜已结束-返回最后一期
     * 排行榜未结束-返回上一期
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     * @param userId 排行榜玩法组件ID
     * @return
     */
    RankingUserPrizeRecord getPreMyRank(String rankPlaywayId, String userId);

    /**
     * 查询制定用户的排名，返回null表明在3000名开外
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     * @param sombodyUserId
     * @return
     */
    Integer getSomebodyRank(String rankPlaywayId, String sombodyUserId);

    Ranking getSomebodyRankInfo(String rankPlaywayId, String sombodyUserId);

    /**
     * 获取新排行榜当前正在进行中的rankingType
     * 如果排行榜已结束，返回的是最后一期
     * 如果排行榜未开始，返回的是第一期
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     * @return
     * @throws BizRuntimeException
     */
    String getCurrentRankingType(String rankPlaywayId) throws BizRuntimeException;

    /**
     * 获取新排行榜上一期的rankingType
     *
     * @param rankPlaywayId 排行榜玩法组件ID
     * @return
     * @throws BizRuntimeException
     */
    String getPrefixRankingType(String rankPlaywayId) throws BizRuntimeException;

    /**
     * 将某个用户加入排行榜的黑名单
     *
     * @param somebodyUserId 要被风控的用户Id
     * @param rankPlaywayId  排行榜玩法组件ID
     * @return 返回是否将此人加入排行榜黑名单成功
     * 排行榜已经过期结束也会返回false，
     * 用户还未参与榜单也会返回false，
     * 重复标记用户也会返回false
     */
    Boolean invalidSomebodyScore(String rankPlaywayId, String somebodyUserId);

}
