package cn.com.duiba.projectx.sdk.pay;

import org.hibernate.validator.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author zdq
 * @Description
 * @createTime 2021年10月13日 16:00:00
 */
public class WxPayRedPacketQueryReq implements Serializable {
    /**
     * 支付渠道
     */
    @NotBlank(message = "channelType不能为空")
    private String channelType;

    /**
     * 兑吧appId
     */
    @NotNull(message = "兑吧appId不能为空")
    private Long appId;

    /**
     * 业务主体类型 -- 必传参数
     */
    @NotBlank(message = "subjectType类型不能为空")
    private String subjectType;

    /**
     * 业务方关联活动类型
     */
    @NotNull(message = "bizRelationType不能为空")
    private Integer bizRelationType;

    /**
     * 业务方关联活动id
     */
    @NotBlank(message = "bizRelationId不能为空")
    private String bizRelationId;

    /**
     * 业务方订单号
     */
    @NotBlank(message = "bizOrderNo不能为空")
    private String bizOrderNo;

    /**
     * 订单类型
     * 商户订单号/支付订单号
     * MCHT:通过商户订单号获取红包信息。
     */
    @NotBlank(message = "billType不能为空")
    private String billType;


    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public Integer getBizRelationType() {
        return bizRelationType;
    }

    public void setBizRelationType(Integer bizRelationType) {
        this.bizRelationType = bizRelationType;
    }

    public String getBizRelationId() {
        return bizRelationId;
    }

    public void setBizRelationId(String bizRelationId) {
        this.bizRelationId = bizRelationId;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }
}
