package cn.com.duiba.projectx.sdk.annotation;


import cn.com.duiba.projectx.sdk.riskmddata.MarkTypeEnum;
import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author fengjun
 * @date 2020-07-09
 * @email fengjun@duiba.com.cn
 * @description:
 *  此注解是 EnableRiskControl 的组合注解，会将其获得的值传给EnableRiskControl，
 *  从而实现EnableRiskControl的增强功能，其只能加在
 *  InvitePlaywayInstance.acceptInvite 方法上，否则不会生效。
 * @see EnableRiskControl
 * */
@EnableRiskControl
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface InviteRiskControl {

    /**
     * 风控场景
     */
    @AliasFor(annotation = EnableRiskControl.class,attribute = "value")
    MarkTypeEnum value() default MarkTypeEnum.INVITE;


    /**
     * 默认拦截
     * true 如果是黑名单用户直接拦截
     * false 不拦截黑名单用户
     * @return 是否拦截黑名单用户
     */
    @AliasFor(annotation = EnableRiskControl.class ,attribute = "filterBlack")
    boolean filterBlack() default true;

    /**
     * 如果中了风控，是否直接拒绝，默认为是，也就是外层直接抛异常
     * @return
     */
    @AliasFor(annotation = EnableRiskControl.class, attribute = "directRefuse")
    boolean directRefuse() default true;
}
