package cn.com.duiba.projectx.sdk.component.rank.dto;


import java.util.Date;
import java.util.List;

/**
 * 排行榜-配置表
 */
public class RankConfigDto{

    /**
     * 主键
     */
    private Long id;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 玩法id
     */
    private String playwayId;

    /**
     * 玩法名称
     */
    private String playwayName;

    /**
     * 排行开始时间
     */
    private Date startTime;

    /**
     * 排行榜结束时间
     */
    private Date endTime;

    /**
     * 1-自然日 2-自然周 3-自然月 4-自定义
     */
    private Integer resetType;

    /**
     * 自动重置周期（自定义周期使用）
     */
    private Integer versionInterval;

    /**
     * 周期下次重置时间
     */
    private Date nextResetTime;

    /**
     * 开奖时间间隔
     */
    private Integer opInterval;

    /**
     * 开奖时间 hh:mm
     */
    private String opTime;

    /**
     * 下期开奖时间
     */
    private Date nextOpTime;

    /**
     * 是否自动续期
     */
    private Boolean autoContinue;

    /**
     * 当前排行榜是否需要开奖
     */
    private Boolean lottery;

    /**
     * 1-自动开奖 2-手动开奖
     */
    private Integer opWay;

    /**
     * 当前期次
     */
    private Integer currentVersion;

    /**
     * 当前期次名称（yyyyMMdd）
     */
    private String currentRankingType;

    /**
     * 档期期次归档id
     */
    private Long currentArchiveId;

    /**
     * 奖项json
     */
    private String optionJson;

    /**
     * 排行榜状态 0-关闭 1-开启
     */
    private Boolean openStatus;

    private List<LeaderboardOptionDto> options;

    /**
     * 创建时间
     */
    private Date gmtCreated;

    /**
     * 更新时间
     */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setResetType(Integer resetType) {
        this.resetType = resetType;
    }

    public Integer getResetType() {
        return resetType;
    }

    public void setVersionInterval(Integer versionInterval) {
        this.versionInterval = versionInterval;
    }

    public Integer getVersionInterval() {
        return versionInterval;
    }

    public void setNextResetTime(Date nextResetTime) {
        this.nextResetTime = nextResetTime;
    }

    public Date getNextResetTime() {
        return nextResetTime;
    }

    public void setOpInterval(Integer opInterval) {
        this.opInterval = opInterval;
    }

    public Integer getOpInterval() {
        return opInterval;
    }

    public String getOpTime() {
        return opTime;
    }

    public void setOpTime(String opTime) {
        this.opTime = opTime;
    }

    public void setNextOpTime(Date nextOpTime) {
        this.nextOpTime = nextOpTime;
    }

    public Date getNextOpTime() {
        return nextOpTime;
    }

    public Boolean getAutoContinue() {
        return autoContinue;
    }

    public void setAutoContinue(Boolean autoContinue) {
        this.autoContinue = autoContinue;
    }

    public void setOpWay(Integer opWay) {
        this.opWay = opWay;
    }

    public Integer getOpWay() {
        return opWay;
    }

    public void setCurrentVersion(Integer currentVersion) {
        this.currentVersion = currentVersion;
    }

    public Integer getCurrentVersion() {
        return currentVersion;
    }

    public void setCurrentRankingType(String currentRankingType) {
        this.currentRankingType = currentRankingType;
    }

    public String getCurrentRankingType() {
        return currentRankingType;
    }

    public void setGmtCreated(Date gmtCreated) {
        this.gmtCreated = gmtCreated;
    }

    public Date getGmtCreated() {
        return gmtCreated;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public Long getCurrentArchiveId() {
        return currentArchiveId;
    }

    public void setCurrentArchiveId(Long currentArchiveId) {
        this.currentArchiveId = currentArchiveId;
    }

    public Boolean getLottery() {
        return lottery;
    }

    public void setLottery(Boolean lottery) {
        this.lottery = lottery;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getOptionJson() {
        return optionJson;
    }

    public void setOptionJson(String optionJson) {
        this.optionJson = optionJson;
    }

    public Boolean getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Boolean openStatus) {
        this.openStatus = openStatus;
    }

    public List<LeaderboardOptionDto> getOptions() {
        return options;
    }

    public void setOptions(List<LeaderboardOptionDto> options) {
        this.options = options;
    }

    public String getPlaywayId() {
        return playwayId;
    }

    public void setPlaywayId(String playwayId) {
        this.playwayId = playwayId;
    }

    public String getPlaywayName() {
        return playwayName;
    }

    public void setPlaywayName(String playwayName) {
        this.playwayName = playwayName;
    }
}

