package cn.com.duiba.projectx.sdk.component.tmraward.enums;

/**
 * @program: projectx
 * @description: 明日奖励组件 - 奖励发放类型枚举
 * @author: Simba
 * @create: 2021-04-27 17:29
 **/
public enum GiveTypeEnum {

    DIRECT(1, "直接发放"),

    EXTRA(2, "额外奖励"),
    ;

    private int type;

    private String desc;

    GiveTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static GiveTypeEnum toEnum(int type) {
        for (GiveTypeEnum p : values()) {
            if (p.type == type) {
                return p;
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}

