package cn.com.duiba.projectx.sdk.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

public enum CommonEnum {
    V0(0, "0"),
    V1(1, "1"),
    V2(2, "2"),
    ;

    private int code;
    private String desc;

    CommonEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final ImmutableMap<Integer, CommonEnum> ALL_MAP;
    static {
        Map<Integer, CommonEnum> tmpMap = Maps.newHashMap();
        for(CommonEnum tmpEnum : CommonEnum.values()) {
            tmpMap.put(tmpEnum.getCode(), tmpEnum);
        }
        ALL_MAP = ImmutableMap.copyOf(tmpMap);
    }

    public static CommonEnum getByCode(Integer code) {
        return ALL_MAP.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
