package cn.com.duiba.projectx.sdk.pay;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @program: projectx
 * @author: fenghuohuo
 * @create: 2023-02-16 10:48
 **/
public class AliTransferToUserReq {


    /**
     * 业务方的业务唯一编号
     **/
    @NotBlank(message = "业务编号不能为空")
    private String bizNo;

    /**
     * 支付金额，单位分
     **/
    @NotNull(message = "金额不能为null")
    private Long amount;

    /**
     * 收款账号
     **/
    @NotBlank(message = "收款账号不能为空")
    private String payeeNo;

    /**
     * 转账备注
     */
    private String remark;

    /**
     * 付款方自定义商户号(支付宝id)
     */
    @NotBlank(message = "商户号不能为空")
    private String merchantNo;

    public String getBizNo() {
        return bizNo;
    }

    public AliTransferToUserReq setBizNo(String bizNo) {
        this.bizNo = bizNo;
        return this;
    }

    public Long getAmount() {
        return amount;
    }

    public AliTransferToUserReq setAmount(Long amount) {
        this.amount = amount;
        return this;
    }

    public String getPayeeNo() {
        return payeeNo;
    }

    public AliTransferToUserReq setPayeeNo(String payeeNo) {
        this.payeeNo = payeeNo;
        return this;
    }

    public String getRemark() {
        return remark;
    }

    public AliTransferToUserReq setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getMerchantNo() {
        return merchantNo;
    }

    public AliTransferToUserReq setMerchantNo(String merchantNo) {
        this.merchantNo = merchantNo;
        return this;
    }
}
