package cn.com.duiba.projectx.sdk.pay;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.Serializable;
import java.util.List;

/**
 * @author zhangdaqing
 * @Description
 * @date 2024/6/19 12:32
 */
public class WxTransReq implements Serializable {
    /**
     * 请求业务订单号
     */
    @NotBlank(message = "bizNo must not be null")
    @Size(max = 32, message = "bizNo不能超过32")
    private String bizNo;
    /**
     * 商户ID
     */
    @NotBlank(message = "mchId must not be null")
    @Size(max = 32, message = "mchId不能超过32")
    private String mchId;

    /**
     * 商户appid
     * 说明：申请商户号的appid或商户号绑定的appid（企业号corpid即为此appid）
     * 必填，string(32)
     */
    @NotBlank(message = "appId must not be null")
    @Size(max = 32, message = "appId不能超过32")
    private String appId;

    /**
     * 批次名称
     * 说明：该笔批量转账的名称
     * 必填，string(32)
     */
    @NotBlank(message = "batchName must not be null")
    @Size(max = 32, message = "batchName不能超过32")
    private String batchName;

    /**
     * 批次备注
     * 说明：转账说明，UTF8编码，最多允许32个字符
     * 必填，string(32)
     */
    @NotBlank(message = "batchRemark must not be null")
    @Size(max = 32, message = "batchRemark不能超过32")
    private String batchRemark;

    /**
     * 转账总金额
     * 说明：转账金额单位为“分”。转账总金额必须与批次内所有明细转账金额之和保持一致，否则无法发起转账操作
     * 必填
     */
    @NotNull(message = "totalAmount must not be null")
    private Long totalAmount;

    /**
     * 转账总笔数
     * 说明：一个转账批次单最多发起一千笔转账。转账总笔数必须与批次内所有明细之和保持一致，否则无法发起转账操作
     * 必填
     */
    @NotNull(message = "totalNum must not be null")
    @Min(value = 1, message = "totalNum不能小于1")
    @Max(value = 1000, message = "totalNum不能大于1000")
    private Integer totalNum;

    /**
     * 转账明细列表
     * 说明：发起批量转账的明细列表，最多一千笔
     * 必填
     */
    @Valid
    @NotNull(message = "transferDetailList must not be null")
    @Size(min = 1, max = 1000, message = "transferDetailList size error")
    private List<WxTransferDetailReq> transferDetailList;

    /**
     * 转账场景ID
     * 说明：选填，指定该笔转账使用的转账场景ID
     * 选填，string(36)
     * <a herf="https://pay.weixin.qq.com/docs/merchant/products/batch-transfer-to-balance/operation.html#_5-%E5%9C%BA%E6%99%AF%E7%AE%A1%E7%90%86">官方文档</a>
     */
    @Size(max = 36, message = "transferSceneId不能超过36")
    private String transferSceneId;

    public String getBizNo() {
        return bizNo;
    }

    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getBatchName() {
        return batchName;
    }

    public void setBatchName(String batchName) {
        this.batchName = batchName;
    }

    public String getBatchRemark() {
        return batchRemark;
    }

    public void setBatchRemark(String batchRemark) {
        this.batchRemark = batchRemark;
    }

    public Long getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Long totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public List<WxTransferDetailReq> getTransferDetailList() {
        return transferDetailList;
    }

    public void setTransferDetailList(List<WxTransferDetailReq> transferDetailList) {
        this.transferDetailList = transferDetailList;
    }

    public String getTransferSceneId() {
        return transferSceneId;
    }

    public void setTransferSceneId(String transferSceneId) {
        this.transferSceneId = transferSceneId;
    }
}
