package cn.com.duiba.projectx.sdk.pay.cmb;

import cn.com.duiba.projectx.sdk.pay.BasePayReq;

import javax.validation.constraints.NotNull;

/**
 * 招商银行-掌上生活-H5支付-发起支付请求入参
 *
 * @author songp
 * @date 2024/2/20 5:41 下午
 */
public class CmbLifePayReq extends BasePayReq {

    /**
     * 订单名称（建议十个字符内）
     */
    private String productName;

    /**
     * 掌上生活客户端支付结果重定向页面地址，App支付时不需要传入，需开通白名单权限，请提前告知相关对接人员
     */
    private String returnUrl;

    /**
     * 后台通知接口地址，需要开通网络权限，请提前告知相关对接人员，请使用https协议
     */
    private String notifyUrl;

    /**
     * 订单详情页，用于订单中心展示订单详情，请使用https协议，可不传
     */
    private String orderDetailUrl;

    /**
     * 剩余的可支付时间(秒)，建议24小时内，最长7天，可不传
     */
    private Long payPeriod;

    /**
     * 支付金额(单位分)
     */
    private Integer amount;

    /**
     * 业务ID，业务方根据需要自定义，可不传
     */
    private String bizId;

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getOrderDetailUrl() {
        return orderDetailUrl;
    }

    public void setOrderDetailUrl(String orderDetailUrl) {
        this.orderDetailUrl = orderDetailUrl;
    }

    public Long getPayPeriod() {
        return payPeriod;
    }

    public void setPayPeriod(Long payPeriod) {
        this.payPeriod = payPeriod;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }
}
