package cn.com.duiba.projectx.sdk.pay.gdhx.api;

import cn.com.duiba.projectx.sdk.pay.gdhx.GdhxChargeRequest;
import cn.com.duiba.projectx.sdk.pay.gdhx.GdhxChargeResponse;
import cn.com.duiba.projectx.sdk.pay.gdhx.GdhxPayNotifyRequest;
import cn.com.duiba.projectx.sdk.pay.gdhx.GdhxPayNotifyResp;
import cn.com.duiba.projectx.sdk.pay.gdhx.GdhxRefundChargeRequest;
import cn.com.duiba.projectx.sdk.pay.gdhx.GdhxRefundChargeResponse;

/**
 * Description:
 * <p>华兴银行-支付api
 * date: 2022/8/22 1:47 下午
 *
 * @author huakai
 */
public interface GdhxPayApi {

    /**
     * 创建订单
     * @param request 创建订单请求参数
     * @return 创建订单响应结果
     */
    GdhxChargeResponse createCharge(GdhxChargeRequest request);

    /**
     * 发起退款
     *
     * @param request 发起退款请求参数
     * @return 订单退款响应结果
     */
    GdhxRefundChargeResponse createRefund(GdhxRefundChargeRequest request);

    GdhxPayNotifyResp payOrderNotify(GdhxPayNotifyRequest request);

    /**
     * 查询订单状态
     * 返回结果格式
     * {"success":true,"code":null,"desc":null,"timestamp":1679487375176,"data":"02"}
     * @param uid
     * @param orderNo
     * @return
     * @throws Exception
     */
    String orderMessage(String uid, String orderNo) throws Exception;

}
