package cn.com.duiba.projectx.sdk.pay.icbcelife;

import cn.com.duiba.projectx.sdk.pay.BasePayReq;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * Created by HePeng on 2022/06/13 14:43.
 */
public class IcbcElifeAppPayReq extends BasePayReq {
    private static final long serialVersionUID = 1286027729811853432L;

    /**
     * 业务ID，业务方根据需要自定义
     */
    @NotNull
    private String bizId;

    /**
     * 全积分抵扣标志，0-否，1-是；非1按0处理
     */
    private String allPointsFlag;

    /**
     * 兑换商品所需积分，当all_points_flag为1时必输；订单金额与积分兑换比率由业务规则确定
     */
    private String goodPoints;

    /**
     * 支付金额，单位为分
     */
    @NotNull(message = "缺少支付金额")
    @Min(value = 1, message = "最少支付一分钱")
    private Integer amount;

    /**
     * 商户接收支付成功通知消息URL,当notify_flag为1时必输，最大长度100个字符
     */
    @NotNull
    private String notifyUrl;

    /**
     * 商户附加数据，最多21个汉字字符，原样返回；如业务要求上送营销人员编号，则按照“staffid:num”的格式上送，其中“staffid:”为英文字符，
     * “num”为开头允许为0的9位整数，由工行业务人员提供
     */
    private String attach;

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getAllPointsFlag() {
        return allPointsFlag;
    }

    public void setAllPointsFlag(String allPointsFlag) {
        this.allPointsFlag = allPointsFlag;
    }

    public String getGoodPoints() {
        return goodPoints;
    }

    public void setGoodPoints(String goodPoints) {
        this.goodPoints = goodPoints;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }
}
