package cn.com.duiba.projectx.sdk.pay.union;

import cn.com.duiba.projectx.sdk.pay.BasePayReq;

/**
 * 〈浙江银联支付请求〉
 *
 * @author xcw
 * @create 2020/12/9
 * @since 1.0.0
 */
public class UnionChargeRequest extends BasePayReq {

    /**
     * 业务ID，业务方根据需要自定义，可不传
     */
    private String bizId;
    /**
     * 支付结果通知的地址，不传则走默认配置
     */
    private String resultNotifyUrl;

    /**
     * 支付金额   必传
     */
    private Integer amount;

    /**
     * 商户代码  必传
     */
    private String merId;

    /**
     * 订单详细信息（支持单品）
     */
    private UnionPayAcqAddnData acqAddnData;

    public String getMerId() {
        return merId;
    }

    public void setMerId(String merId) {
        this.merId = merId;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getResultNotifyUrl() {
        return resultNotifyUrl;
    }

    public void setResultNotifyUrl(String resultNotifyUrl) {
        this.resultNotifyUrl = resultNotifyUrl;
    }

    public UnionPayAcqAddnData getAcqAddnData() {
        return acqAddnData;
    }

    public void setAcqAddnData(UnionPayAcqAddnData acqAddnData) {
        this.acqAddnData = acqAddnData;
    }
}